// assets/js/pump_monitor.js - Monitor de bombas en tiempo real (CORREGIDO)
(function() {
  'use strict';

  const cfg = window.__FP_CONFIG || {};
  const api = cfg.api || 'api.php';
  
  let pumpsData = [];
  let isRunning = false;
  let intervalId = null;

  console.log('[PumpMonitor] 🚀 Iniciando monitor...');

  async function fetchPumpStatuses() {
    try {
      const url = api + '?action=get_pumps&_=' + Date.now();
      const response = await fetch(url, { cache: 'no-store' });
      
      if (!response.ok) {
        console.error('[PumpMonitor] ❌ HTTP', response.status);
        return;
      }

      const data = await response.json();
      
      if (data && data.ok && Array.isArray(data.pumps)) {
        pumpsData = data.pumps;
        updatePumpUI(pumpsData);
        console.log('[PumpMonitor] ✓', pumpsData.length, 'bombas actualizadas');
      } else {
        console.warn('[PumpMonitor] ⚠️ Respuesta inesperada');
      }
    } catch (err) {
      console.error('[PumpMonitor] ❌', (err && (err.stack || err.message)) ? (err.stack || err.message) : err);
    }
  }

  function updatePumpUI(pumps) {
    const anyCard = document.querySelector('[data-pump-id]');
    if (!anyCard) return; // page doesn't have pump cards

    pumps.forEach(pump => {
      const pumpId = pump.id;
      const status = pump.status || 'IDLE';
      const statusLower = status.toLowerCase();
      
      const pumpImg = document.querySelector(`[data-pump-id="${pumpId}"] .pump-image img`);
      if (pumpImg && pump.image_url && pumpImg.src !== pump.image_url) {
        pumpImg.src = pump.image_url;
      }

      const indicator = document.querySelector(`[data-pump-id="${pumpId}"] .pump-status-indicator`);
      if (indicator) {
        indicator.className = `pump-status-indicator ${statusLower}`;
      }

      const pumpStatus = document.querySelector(`[data-pump-id="${pumpId}"] .pump-status`);
      if (pumpStatus) {
        pumpStatus.textContent = status;
        pumpStatus.className = `pump-status status-${statusLower}`;
      }

      const card = document.querySelector(`[data-pump-id="${pumpId}"]`);
      if (card) {
        card.setAttribute('data-status', status);
      }
    });
  }

  async function startMonitoring() {
    if (isRunning) return;
    isRunning = true;

    await fetchPumpStatuses();

    if (intervalId) { clearInterval(intervalId); intervalId = null; }

    intervalId = setInterval(() => {
      if (!isRunning) return;
      fetchPumpStatuses();
    }, 2000);

    console.log('[PumpMonitor] ✅ Iniciado (2s)');
  }

  function stopMonitoring() {
    isRunning = false;
    if (intervalId) { clearInterval(intervalId); intervalId = null; }
    console.log('[PumpMonitor] ⏹️ Detenido');
  }

  window.__FP = window.__FP || {};
  window.__FP.getPumpsData = () => pumpsData;
  window.__FP.stopPumpMonitor = stopMonitoring;
  window.__FP.startPumpMonitor = startMonitoring;

  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', () => {
      setTimeout(startMonitoring, 1000);
    });
  } else {
    setTimeout(startMonitoring, 1000);
  }

})();