```markdown
# FuelPOS - PHP + MySQL (XAMPP) - Instalación rápida

Proyecto de ejemplo para gestionar ventas de combustible (POS / Backoffice / Display).

Requisitos:
- XAMPP con Apache + PHP 7.4+ / 8.x y MySQL/MariaDB.
- Extensiones PHP: PDO, fileinfo, mbstring.

Instalación:
1. Copia la carpeta `fuelpos` a tu htdocs (ej: C:\xampp\htdocs\fuelpos).

2. Importa la base de datos:
   - Abre http://localhost/phpmyadmin
   - Selecciona Importar -> subir `db.sql` o pega su contenido en SQL y ejecutar.

3. Configura:
   - Abre `config.php` y ajusta base_url si usas otro nombre de carpeta.
   - Confirma credenciales MySQL (por defecto root sin contraseña).

4. Crea administrador:
   - Abre en el navegador: http://localhost/fuelpos/admin_setup.php
   - Crea un usuario admin y contraseña. BORRA admin_setup.php después de crear el admin.

5. Backend / Backoffice:
   - Login: http://localhost/fuelpos/admin_login.php
   - Dashboard: http://localhost/fuelpos/admin/index.php

6. POS (Caja) para uso en PC o tablet:
   - http://localhost/fuelpos/pos/index.php

7. Display (pantalla de sala/forecourt):
   - http://localhost/fuelpos/display/index.php

8. Subida de videos:
   - Desde Backoffice (no implementado UI avanzada) se puede ampliar; los videos se almacenan en /uploads.

Notas y mejoras recomendadas:
- Cambiar contraseña de admin y usar HTTPS en producción.
- Integrar impresión térmica según modelo (current prints desde ventana del navegador).
- Integración con dispensadores reales: crear adaptador que reciba lecturas de pulsos o API del proveedor.
- Para alta concurrencia usar bloqueo más estricto en creación de códigos/seq (actualmente usa timestamp+rand).
- Puedo adaptar para integración con gateway de pagos (producción requiere PCI).
```