<?php
// File: /fuelpos/admin/index.php
require __DIR__ . '/../init.php';
require_login();

if (!function_exists('esc')) {
    function esc($s){ return htmlspecialchars((string)$s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
}

$is_admin = !empty($_SESSION['is_admin']);
$username = $_SESSION['username'] ?? '';
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <title>SolutionPOS - Admin</title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
  <style>
    body {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      min-height: 100vh;
    }
    
    .admin-container {
      background: white;
      border-radius: 20px;
      padding: 40px;
      box-shadow: 0 20px 60px rgba(0,0,0,0.3);
      margin-top: 30px;
      margin-bottom: 30px;
    }
    
    .admin-header {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      padding: 30px;
      border-radius: 15px;
      margin-bottom: 40px;
      box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);
    }
    
    .admin-header h3 {
      margin: 0;
      font-weight: 700;
      font-size: 28px;
    }
    
    .admin-header p {
      margin: 8px 0 0 0;
      opacity: 0.95;
      font-size: 16px;
    }
    
    .admin-card {
      border: none;
      border-radius: 15px;
      transition: all 0.3s ease;
      height: 100%;
      overflow: hidden;
      box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    }
    
    .admin-card:hover {
      transform: translateY(-8px);
      box-shadow: 0 15px 35px rgba(0,0,0,0.15);
    }
    
    .admin-card .card-body {
      padding: 25px;
      display: flex;
      flex-direction: column;
      min-height: 180px;
    }
    
    .card-icon {
      font-size: 42px;
      margin-bottom: 15px;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
    }
    
    .admin-card h5 {
      font-weight: 700;
      color: #2c3e50;
      margin-bottom: 10px;
      font-size: 20px;
    }
    
    .admin-card p {
      color: #7f8c8d;
      flex-grow: 1;
      margin-bottom: 15px;
      font-size: 14px;
    }
    
    .admin-card .btn {
      border-radius: 10px;
      padding: 10px 20px;
      font-weight: 600;
      transition: all 0.3s ease;
      border: 2px solid transparent;
    }
    
    .admin-card .btn-primary {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      border: none;
    }
    
    .admin-card .btn-primary:hover {
      background: linear-gradient(135deg, #764ba2 0%, #667eea 100%);
      transform: scale(1.05);
    }
    
    .admin-card .btn-outline-primary {
      border-color: #667eea;
      color: #667eea;
    }
    
    .admin-card .btn-outline-primary:hover {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      border-color: transparent;
      color: white;
    }
    
    .navbar {
      background: white !important;
      box-shadow: 0 4px 20px rgba(0,0,0,0.1);
      padding: 15px 0;
    }
    
    .navbar-brand {
      font-size: 24px;
      font-weight: 700;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
    }
    
    .navbar .btn {
      border-radius: 10px;
      padding: 8px 20px;
      font-weight: 600;
      transition: all 0.3s ease;
    }
    
    .section-title {
      font-weight: 700;
      color: #2c3e50;
      margin-top: 40px;
      margin-bottom: 25px;
      padding-bottom: 10px;
      border-bottom: 3px solid #667eea;
      font-size: 22px;
    }
  </style>
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-light">
  <div class="container">
    <a class="navbar-brand" href="<?= site('index.php') ?>">
      <i class="bi bi-shop"></i> SolutionPOS
    </a>
    <div class="ms-auto d-flex gap-2">
      <a class="btn btn-outline-primary btn-sm" href="<?= site('index.php') ?>">
        <i class="bi bi-speedometer2"></i> Dashboard
      </a>
      <a class="btn btn-outline-success btn-sm" href="<?= site('pos/index.php') ?>">
        <i class="bi bi-cart3"></i> Abrir POS
      </a>
      <a class="btn btn-outline-danger btn-sm" href="<?= site('admin_logout.php') ?>">
        <i class="bi bi-box-arrow-right"></i> Salir
      </a>
    </div>
  </div>
</nav>

<div class="container">
  <div class="admin-container">
    
    <div class="admin-header">
      <h3><i class="bi bi-gear-fill"></i> Panel de Administración</h3>
      <p>Bienvenido, <strong><?= esc($username) ?></strong> <?= $is_admin ? '<span class="badge bg-warning text-dark ms-2">Administrador</span>' : '' ?></p>
    </div>

    <!-- SECCIÓN: GESTIÓN PRINCIPAL -->
    <h4 class="section-title"><i class="bi bi-sliders"></i> Gestión Principal</h4>
    <div class="row g-4">
      
      <div class="col-12 col-md-6 col-lg-4">
        <div class="card admin-card">
          <div class="card-body">
            <div class="card-icon"><i class="bi bi-people-fill"></i></div>
            <h5>Usuarios</h5>
            <p>Crear y editar usuarios del sistema</p>
            <a class="btn btn-primary w-100" href="<?= site('admin/users.php') ?>">
              Gestionar usuarios
            </a>
          </div>
        </div>
      </div>

      <div class="col-12 col-md-6 col-lg-4">
        <div class="card admin-card">
          <div class="card-body">
            <div class="card-icon"><i class="bi bi-box-seam-fill"></i></div>
            <h5>Productos</h5>
            <p>Agregar y editar productos</p>
            <a class="btn btn-outline-primary w-100" href="<?= site('admin/products.php') ?>">
              Gestionar productos
            </a>
          </div>
        </div>
      </div>

      <div class="col-12 col-md-6 col-lg-4">
        <div class="card admin-card">
          <div class="card-body">
            <div class="card-icon"><i class="bi bi-fuel-pump-fill"></i></div>
            <h5>Bombas y Mangueras</h5>
            <p>Gestionar bombas y mangueras</p>
            <a class="btn btn-outline-primary w-100" href="<?= site('admin/pumps.php') ?>">
              Gestionar bombas
            </a>
          </div>
        </div>
      </div>

      <div class="col-12 col-md-6 col-lg-4">
        <div class="card admin-card">
          <div class="card-body">
            <div class="card-icon"><i class="bi bi-building"></i></div>
            <h5>Estación</h5>
            <p>Configurar datos de la estación</p>
            <a class="btn btn-outline-primary w-100" href="<?= esc(site('admin/stations.php')) ?>">
              Gestionar estación
            </a>
          </div>
        </div>
      </div>

      <div class="col-12 col-md-6 col-lg-4">
        <div class="card admin-card">
          <div class="card-body">
            <div class="card-icon"><i class="bi bi-droplet-fill"></i></div>
            <h5>Tanques</h5>
            <p>Gestionar tanques e inventario</p>
            <a class="btn btn-outline-primary w-100" href="<?= esc(site('admin/tanques.php')) ?>">
              Gestionar tanques
            </a>
          </div>
        </div>
      </div>

      <div class="col-12 col-md-6 col-lg-4">
        <div class="card admin-card">
          <div class="card-body">
            <div class="card-icon"><i class="bi bi-credit-card-fill"></i></div>
            <h5>Tipos de Pago</h5>
            <p>Gestionar métodos de pago</p>
            <a class="btn btn-outline-primary w-100" href="<?= esc(site('admin/payment_types.php')) ?>">
              Gestionar tipos de pago
            </a>
          </div>
        </div>
      </div>

      <div class="col-12 col-md-6 col-lg-4">
        <div class="card admin-card">
          <div class="card-body">
            <div class="card-icon"><i class="bi bi-briefcase-fill"></i></div>
            <h5>Empresas</h5>
            <p>Gestionar empresas y clientes corporativos</p>
            <a class="btn btn-outline-primary w-100" href="<?= esc(site('admin/empresa.php')) ?>">
              Gestionar empresas
            </a>
          </div>
        </div>
      </div>

      <div class="col-12 col-md-6 col-lg-4">
        <div class="card admin-card">
          <div class="card-body">
            <div class="card-icon"><i class="bi bi-person-badge-fill"></i></div>
            <h5>Empleados</h5>
            <p>Gestionar empleados de empresas</p>
            <a class="btn btn-outline-primary w-100" href="<?= esc(site('admin/empleados.php')) ?>">
              Gestionar empleados
            </a>
          </div>
        </div>
      </div>

    </div>

    <!-- SECCIÓN: DOCUMENTOS Y REPORTES -->
    <h4 class="section-title mt-5"><i class="bi bi-file-earmark-text-fill"></i> Documentos y Reportes</h4>
    <div class="row g-4">
      
      <div class="col-12 col-md-6 col-lg-4">
        <div class="card admin-card">
          <div class="card-body">
            <div class="card-icon"><i class="bi bi-receipt-cutoff"></i></div>
            <h5>Comprobantes Fiscales</h5>
            <p>Gestionar comprobantes fiscales NCF</p>
            <a class="btn btn-outline-primary w-100" href="<?= esc(site('ncf/index.php')) ?>">
              Gestionar comprobantes
            </a>
          </div>
        </div>
      </div>

      <div class="col-12 col-md-6 col-lg-4">
        <div class="card admin-card">
          <div class="card-body">
            <div class="card-icon"><i class="bi bi-graph-up-arrow"></i></div>
            <h5>Reportes de Ventas</h5>
            <p>Ver reportes y estadísticas</p>
            <a class="btn btn-outline-primary w-100" href="<?= esc(site('admin/reports.php')) ?>">
              Ver reportes
            </a>
          </div>
        </div>
      </div>

      <div class="col-12 col-md-6 col-lg-4">
        <div class="card admin-card">
          <div class="card-body">
            <div class="card-icon"><i class="bi bi-file-earmark-lock-fill"></i></div>
            <h5>Cierre de Ventas</h5>
            <p>Realizar cierres de caja</p>
            <a class="btn btn-outline-primary w-100" href="<?= esc(site('cierre_ventas.php')) ?>">
              Cierres de ventas
            </a>
          </div>
        </div>
      </div>

      <!-- ✅ NUEVA TARJETA: REPORTE CRÉDITOS EMPLEADOS -->
      <div class="col-12 col-md-6 col-lg-4">
        <div class="card admin-card">
          <div class="card-body">
            <div class="card-icon"><i class="bi bi-file-earmark-bar-graph"></i></div>
            <h5>Reporte Créditos Empleados</h5>
            <p>Consultar transacciones de crédito corporativo</p>
            <a class="btn btn-outline-primary w-100" href="<?= esc(site('admin/reporte_credito_empleado.php')) ?>">
              Ver reporte
            </a>
          </div>
        </div>
      </div>

    </div>

  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>