<?php
// admin_logout.php - cierra sesión y redirige al login de admin
require __DIR__ . '/init.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Opcional: eliminar variables concretas de sesión
$_SESSION = [];

// destruir la cookie de sesión si existe
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

session_destroy();

// Redirigir al login de admin (ajusta si tu ruta difiere)
header('Location: ' . site('admin_login.php'));
exit;