// Pos: pos_create_sale_snippet.js
// Ejemplo: payload que envía cada item con hose_id incluido.
// Coloca este archivo en el directorio de assets/js del POS (ver instrucciones abajo).

async function createSaleWithHoses(items, payment_method = 'cash', user_id = null) {
  // items: array de objetos { product_id, qty, unit_price, hose_id }
  const payload = {
    action: 'create_sale',
    items: items,
    payment_method: payment_method,
    user_id: user_id
  };

  const res = await fetch('/fuelpos/api.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify(payload)
  });

  const j = await res.json();
  return j;
}

// Ejemplo de uso desde el POS (puedes llamarlo cuando el cajero confirma la venta):
// const items = [
//   { product_id: 2, qty: 3.25, unit_price: 272.9, hose_id: 7 },
//   { product_id: 1, qty: 2.35, unit_price: 290.1, hose_id: 5 }
// ];
// createSaleWithHoses(items, 'cash', currentUserId).then(resp => console.log(resp));