<?php
// Incluir configuración desde el archivo db.php
$config = include('db.php');

// Configuración de conexión usando PDO
try {
    $dsn = "mysql:host={$config['host']};port={$config['port']};dbname={$config['dbname']};charset={$config['charset']}";
    $pdo = new PDO($dsn, $config['user'], $config['pass']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Error al conectar a la base de datos: " . $e->getMessage());
}

// Inicializar variables
$nombreBombero = $_POST['nombre_bombero'] ?? '';
$fechaInicio = $_POST['fecha_inicio'] ?? '';
$fechaFinal = $_POST['fecha_final'] ?? '';
$horaInicio = $_POST['hora_inicio'] ?? '';
$horaFinal = $_POST['hora_final'] ?? '';
$bomba1 = $_POST['bomba1'] ?? '';
$bomba2 = $_POST['bomba2'] ?? '';
$tipodecobro = $_POST['tipodecobro'] ?? '';
$mensaje = "";

// Obtener bombas disponibles
$stmt = $pdo->query("SELECT * FROM pumps");
$pumps = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Procesar registro
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['action']) && $_POST['action'] === 'register') {
    $valor = $_POST['valor'];
    $sql = "INSERT INTO cuadre_bomberos (nombre_bombero, fecha_inicio, fecha_final, hora_inicio, hora_final, bomba1, bomba2, tipodecobro, valor) 
            VALUES (:nombre_bombero, :fecha_inicio, :fecha_final, :hora_inicio, :hora_final, :bomba1, :bomba2, :tipodecobro, :valor)";
    $stmt = $pdo->prepare($sql);

    $params = [
        ':nombre_bombero' => $nombreBombero,
        ':fecha_inicio' => $fechaInicio,
        ':fecha_final' => $fechaFinal,
        ':hora_inicio' => $horaInicio,
        ':hora_final' => $horaFinal,
        ':bomba1' => $bomba1,
        ':bomba2' => $bomba2,
        ':tipodecobro' => $tipodecobro,
        ':valor' => $valor
    ];

    $stmt->execute($params);
    $mensaje = "Cuadre registrado exitosamente.";

    // Limpiar solo el campo de valor
    $_POST['valor'] = '';
}

// Procesar edición
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['action']) && $_POST['action'] === 'edit') {
    $idToEdit = $_POST['id'];
    $nuevoValor = $_POST['valor_edit'];
    $stmt = $pdo->prepare("UPDATE cuadre_bomberos SET valor = :valor WHERE id = :id");
    $stmt->execute([
        ':valor' => $nuevoValor,
        ':id' => $idToEdit
    ]);
    $mensaje = "Registro editado correctamente.";
}

// Procesar eliminación
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['action']) && $_POST['action'] === 'delete') {
    $idToDelete = $_POST['id'];
    $pdo->prepare("DELETE FROM cuadre_bomberos WHERE id = :id")->execute([':id' => $idToDelete]);
    $mensaje = "Registro eliminado correctamente.";
}

// Obtener los registros actuales (mientras no se haya imprimido)
if ($_SERVER["REQUEST_METHOD"] !== "POST" || isset($_POST['action']) && $_POST['action'] !== 'clear') {
    // Mostrar solo los registros añadidos recientemente (últimos 10)
    $registrosQuery = $pdo->query("SELECT * FROM cuadre_bomberos ORDER BY id DESC LIMIT 10");
    $registros = $registrosQuery->fetchAll(PDO::FETCH_ASSOC);
}

// Procesar "Imprimir" (clear)
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['action']) && $_POST['action'] === 'clear') {
    $registros = [];
    $mensaje = "Registros limpiados después de imprimir.";
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cuadre de Bomberos</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background: #f7f7f7;
        }
        header {
            background: #0056b3;
            color: white;
            padding: 10px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        header a, header form button {
            color: white;
            text-decoration: none;
            padding: 10px 15px;
            background: #004a9f;
            border-radius: 5px;
            border: none;
            cursor: pointer;
        }
        main {
            padding: 20px;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border-radius: 8px;
            padding: 20px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.15);
        }
        h1, h2 {
            color: #333;
        }
        form label {
            display: block;
            margin: 10px 0 5px;
        }
        form input, form select, form button {
            width: 100%;
            padding: 8px;
            margin-bottom: 15px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table th, table td {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: left;
        }
        table th {
            background: #f3f3f3;
        }
        .action-buttons form {
            display: inline-block;
        }
        .action-buttons button {
            margin-right: 5px;
        }
    </style>
</head>
<body>
<header>
    <h2>Fuel POS - Cuadre de Bomberos</h2>
    <a href="/index.php">Inicio</a>
</header>
<main>
    <div class="container">
        <h1>Registrar Cuadre de Bomberos</h1>
        <?php if (!empty($mensaje)) echo "<p style='color: green;'>$mensaje</p>"; ?>
        <form method="POST">
            <input type="hidden" name="action" value="register">
            <label>Nombre del Bombero:</label>
            <input type="text" name="nombre_bombero" value="<?= htmlspecialchars($nombreBombero) ?>" required>

            <label>Fecha Inicio:</label>
            <input type="date" name="fecha_inicio" value="<?= htmlspecialchars($fechaInicio) ?>" required>

            <label>Fecha Final:</label>
            <input type="date" name="fecha_final" value="<?= htmlspecialchars($fechaFinal) ?>" required>

            <label>Hora Inicio:</label>
            <input type="time" name="hora_inicio" value="<?= htmlspecialchars($horaInicio) ?>" required>

            <label>Hora Final:</label>
            <input type="time" name="hora_final" value="<?= htmlspecialchars($horaFinal) ?>" required>

            <label>Bomba 1:</label>
            <select name="bomba1" required>
                <?php foreach ($pumps as $pump): ?>
                    <option value="<?= $pump['id'] ?>" <?= $pump['id'] == $bomba1 ? 'selected' : '' ?>>
                        <?= htmlspecialchars($pump['name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>

            <label>Bomba 2:</label>
            <select name="bomba2" required>
                <?php foreach ($pumps as $pump): ?>
                    <option value="<?= $pump['id'] ?>" <?= $pump['id'] == $bomba2 ? 'selected' : '' ?>>
                        <?= htmlspecialchars($pump['name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>

            <label>Tipo de Cobro:</label>
            <select name="tipodecobro" required>
                <option value="efectivo" <?= $tipodecobro === 'efectivo' ? 'selected' : '' ?>>Efectivo</option>
                <option value="tarjeta" <?= $tipodecobro === 'tarjeta' ? 'selected' : '' ?>>Tarjeta</option>
                <option value="credito" <?= $tipodecobro === 'credito' ? 'selected' : '' ?>>Crédito</option>
                <option value="otros" <?= $tipodecobro === 'otros' ? 'selected' : '' ?>>Otros</option>
            </select>

            <label>Valor:</label>
            <input type="number" name="valor" step="0.01" value="<?= $_POST['valor'] ?? '' ?>" required>

            <button type="submit">Registrar</button>
        </form>

        <?php if (!empty($registros)): ?>
        <h2>Registros Actuales</h2>
        <table>
            <tr>
                <th>ID</th>
                <th>Bombero</th>
                <th>Fecha Inicio</th>
                <th>Fecha Final</th>
                <th>Hora Inicio</th>
                <th>Hora Final</th>
                <th>Tipo de Cobro</th>
                <th>Valor</th>
                <th>Acciones</th>
            </tr>
            <?php foreach ($registros as $registro): ?>
                <tr>
                    <td><?= htmlspecialchars($registro['id']) ?></td>
                    <td><?= htmlspecialchars($registro['nombre_bombero']) ?></td>
                    <td><?= htmlspecialchars($registro['fecha_inicio']) ?></td>
                    <td><?= htmlspecialchars($registro['fecha_final']) ?></td>
                    <td><?= htmlspecialchars($registro['hora_inicio']) ?></td>
                    <td><?= htmlspecialchars($registro['hora_final']) ?></td>
                    <td><?= htmlspecialchars($registro['tipodecobro']) ?></td>
                    <td><?= htmlspecialchars(number_format($registro['valor'], 2)) ?></td>
                    <td class="action-buttons">
                        <!-- Botón de Editar -->
                        <form method="POST" style="display: inline;">
                            <input type="hidden" name="action" value="edit">
                            <input type="hidden" name="id" value="<?= $registro['id'] ?>">
                            <input type="number" name="valor_edit" step="0.01" placeholder="Nuevo valor" required>
                            <button type="submit">Editar</button>
                        </form>
                        <!-- Botón de Eliminar -->
                        <form method="POST" style="display: inline;">
                            <input type="hidden" name="action" value="delete">
                            <input type="hidden" name="id" value="<?= $registro['id'] ?>">
                            <button type="submit" style="color: red;">Eliminar</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; ?>
        </table>
        <form method="POST">
            <button type="submit" name="action" value="clear">Imprimir y Limpiar</button>
        </form>
        <?php endif; ?>
    </div>
</main>
</body>
</html>