# Fusión Wayne v3 — API (carpeta `/api/` provista)
**Fecha:** 2025-11-05

Este documento describe los endpoints **existentes** que enviaste. Todos responden **JSON**.

> Base URL típica: `http://172.17.125.102/api/`

---

## `prices.php`
- **Método:** GET
- **Parámetros:** —
- **Respuesta:** `{ "prices": [ ... ] }` (precios por manguera/producto)
- **Notas:** Cache-Control `max-age=30`

**Ejemplo**  
`GET /api/prices.php`

---

## `sales.php`
- **Método:** GET
- **Parámetros (opcionales):**
  - `init` (string, formato de fecha esperado por backend; comúnmente `YYYYMMDD`)
  - `end`  (string, idem)
- **Respuesta:**
  - Si **incluyes** `init`/`end`: `{ "sales": [ ... ] }` — lista de ventas en rango.
  - Si **no** incluyes: `{ "sales": { "today":..., "yesterday":..., "thisweek":..., "lastweek":..., "thismonth":..., "lastmonth":... } }` — totales por período.
- **Notas:** `Cache-Control: no-cache`

**Ejemplos**  
`GET /api/sales.php`  
`GET /api/sales.php?init=20251101&end=20251104`

---

## `volumeByHose.php`
- **Método:** GET
- **Parámetros:** —
- **Respuesta:** `{ "volume": [ ... ] }` (volumen vendido del día por manguera)
- **Notas:** Cache-Control `max-age=30`

**Ejemplo**  
`GET /api/volumeByHose.php`

---

## `attendant.php`
- **Método:** GET
- **Parámetros:** —
- **Respuesta:** `{ "attendants": [ ... ] }` (lista de atendentes/vendedores con KPIs del día)
- **Notas:** Usa ajuste de fecha `date_fixed('Ymd')`. Cache 30s.

**Ejemplo**  
`GET /api/attendant.php`

---

## `alarms.php`
- **Método:** GET
- **Parámetros:** —
- **Respuesta:** `{ "alarms": [ ... ] }` (alarmas activas)

**Ejemplo**  
`GET /api/alarms.php`

---

## `tanks.php`
- **Método:** GET
- **Parámetros:** —
- **Respuesta:**  
  ```json
  {
    "tanks": [
      {
        "id": ..., "product": ..., "unit": "...",
        "deliveries": [ ... ],
        ...otros campos del tanque...
      }
    ]
  }
  ```
- **Notas:** Resuelve `unit` por producto y agrega `deliveries` por tanque con el `dateFormat` del sistema.

**Ejemplo**  
`GET /api/tanks.php`

---

## `modules.php`
- **Método:** GET
- **Parámetros:** —
- **Respuesta:** `{ "system": [ ... ] }` — información del sistema (incluye "support email" y "support phone").

**Ejemplo**  
`GET /api/modules.php`

---

## `changeRedirect.php`
- **Método:** GET
- **Parámetros (opcionales):**
  - `glanceredirect`: `"true"` o `"false"`
- **Comportamiento:**
  - Si se envía `glanceredirect=true/false`, **actualiza** el flag del sistema.
  - Siempre devuelve el valor actual de `"glance redirect"` (como JSON simple).
- **Respuesta:** `true`/`false` (JSON)

**Ejemplos**  
`GET /api/changeRedirect.php` (consulta)  
`GET /api/changeRedirect.php?glanceredirect=true` (activar)  
`GET /api/changeRedirect.php?glanceredirect=false` (desactivar)

---

## `translate.php`
- **Método:** GET
- **Parámetros:** `q` (texto a traducir/obtener del archivo de localización)
- **Respuesta:** `{ "translation": "..." }`
- **Notas:** Requiere que la sesión/seguridad del sistema permita acceso (`CCSecurityRedirect` existe).

**Ejemplo**  
`GET /api/translate.php?q=today`

---

# Notas Generales
- Todos los endpoints definidos aquí **usan PHP** y responden JSON.
- Algunos archivos internos (`classes/*DAO.php`) determinan la estructura exacta de cada objeto (mangueras, ventas, tanques, etc.).
- Para endpoints de **control de bombas / precios** no presentes, probaremos rutas tipo `/api/pump/...`, `/api/fuel/...`, `/api/transaction/...` en la instalación completa.

# Cliente y Tester
- **Cliente PHP listo para usar:** `fusion_api_client.php`  
  - funciones: `getPrices()`, `getSales(init,end)`, `getVolumeByHose()`, `getAttendants()`, `getAlarms()`, `getSystemModules()`, `getTanks()`, `changeGlanceRedirect(flag)`, `translate(q)`
- **Tester minimal:** `test_fusion_api_min.php`  
  - UI para probar cada endpoint con base URL configurable.

