<?php
// replay_set_3011.php — Envía todos los payload_open_*.hex.txt a 192.168.0.77:3011 con framing NNNNN|2| y guarda respuestas.

$host = '192.168.0.77';
$port = 3011;
$dir  = getenv('USERPROFILE') . DIRECTORY_SEPARATOR . 'Desktop' . DIRECTORY_SEPARATOR . 'streams_open';
$out  = __DIR__ . DIRECTORY_SEPARATOR . 'responses_open';
if (!is_dir($out)) mkdir($out, 0777, true);

function hexToBinStrict($hex) {
  $hex = preg_replace('/[^0-9A-Fa-f]/','', $hex);
  if ($hex === '' || strlen($hex)%2) return '';
  return hex2bin($hex);
}
function buildFrame($payloadHex) {
  $bin = hexToBinStrict($payloadHex);
  $len = strlen($bin);
  $header = str_pad((string)$len, 5, '0', STR_PAD_LEFT) . '|2|';
  return $header . $bin;
}
function hexdump($data, $max=256) {
  $hex = strtoupper(bin2hex(substr($data,0,$max)));
  return implode(' ', str_split($hex,2));
}

$files = glob($dir . DIRECTORY_SEPARATOR . 'payload_open_*.hex.txt');
sort($files, SORT_NATURAL);
if (!$files) { echo "No encontré payload_open_*.hex.txt en $dir\n"; exit(1); }

echo "[*] Enviando " . count($files) . " payload(s) desde $dir\n";

$fp = @stream_socket_client("tcp://{$host}:{$port}", $errno, $errstr, 5);
if (!$fp) { die("No conecta: $errstr ($errno)\n"); }
stream_set_blocking($fp, false);

foreach ($files as $idx => $path) {
  $hex = file_get_contents($path);
  $frame = buildFrame($hex);
  $n = fwrite($fp, $frame);
  echo sprintf("[>] %s (%d bytes enviados) header=%s\n",
    basename($path), $n, substr($frame,0,8));

  // Esperar respuesta hasta 5s, guardar lo que llegue
  $start = microtime(true); $buf = '';
  while ((microtime(true)-$start) < 5.0) {
    $chunk = fread($fp, 8192);
    if ($chunk !== false && $chunk !== '') { $buf .= $chunk; usleep(100000); } else { usleep(100000); }
  }
  if ($buf !== '') {
    $stamp = date('Ymd_His') . '_idx' . str_pad($idx+1,2,'0',STR_PAD_LEFT);
    file_put_contents($out . DIRECTORY_SEPARATOR . $stamp . '_resp.bin', $buf);
    echo "    [<] Respuesta (" . strlen($buf) . " bytes) HEX: " . hexdump($buf) . "\n";
  } else {
    echo "    [<] (sin respuesta inmediata)\n";
  }

  // Pequeña pausa entre envíos
  usleep(300000);
}

fclose($fp);
echo "[*] Listo. Revisa: $out\n";
