<?php
/**
 * router_action_tester.php
 * Probador simple de acciones predefinidas contra ATGConsole/communication/routerAction.php
 * Úsalo cuando esa ruta sea accedida por HTTP en tu instalación.
 */
declare(strict_types=1);

function req(string $url, array $params=[]): array {
  $ch = curl_init();
  if ($params) { // POST
    curl_setopt_array($ch,[CURLOPT_URL=>$url, CURLOPT_POST=>true, CURLOPT_POSTFIELDS=>$params, CURLOPT_RETURNTRANSFER=>true, CURLOPT_TIMEOUT=>10]);
  } else {       // GET
    curl_setopt_array($ch,[CURLOPT_URL=>$url, CURLOPT_RETURNTRANSFER=>true, CURLOPT_TIMEOUT=>10]);
  }
  $raw = curl_exec($ch);
  $err = curl_error($ch);
  $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  curl_close($ch);
  return [$code,$err,$raw];
}

$base = $_POST['base'] ?? ($_GET['base'] ?? 'http://localhost/spiritWeb'); // AJUSTA al host real
$path = "/ATGConsole/communication/routerAction.php";                       // según tu árbol
$url  = rtrim($base,'/').$path;

$action = $_POST['action'] ?? $_GET['action'] ?? '';
if ($action==='') {
  header('Content-Type: text/html; charset=utf-8');
  ?>
  <h1>Router Action Tester</h1>
  <form method="post">
    <label>Base URL: <input name="base" value="<?=htmlspecialchars($base,ENT_QUOTES)?>" size="60"></label>
    <p>Acciones:</p>
    <button name="action" value="ack_alarms">ACK Alarms</button>
    <button name="action" value="tanks_ack_alarms">Tanks ACK Alarms</button>
    <button name="action" value="switch_startup_console">Switch Startup Console</button>
    <hr>
    <p>Parámetros para Tanks ACK Alarms:</p>
    <label>LOC: <input name="loc"></label>
    <label>LOC_ID: <input name="loc_id"></label>
    <label>TYPE: <input name="type"></label>
  </form>
  <?php
  exit;
}

switch ($action) {
  case 'ack_alarms':
    // RouterAction arma: REQ_ACK_ALARMS con SOURCE=ATG Console
    list($code,$err,$raw) = req($url, ["action"=>"ack_alarms"]);
    break;
  case 'tanks_ack_alarms':
    $loc = $_POST['loc'] ?? '';
    $loc_id = $_POST['loc_id'] ?? '';
    $type = $_POST['type'] ?? '';
    list($code,$err,$raw) = req($url, ["action"=>"tanks_ack_alarms","loc"=>$loc,"loc_id"=>$loc_id,"type"=>$type]);
    break;
  case 'switch_startup_console':
    list($code,$err,$raw) = req($url, ["action"=>"switch_startup_console"]);
    break;
  default:
    $code=400; $err="Acción no soportada"; $raw="";
}

header('Content-Type: text/plain; charset=utf-8');
echo "URL: $url\n";
echo "HTTP: $code\n";
if ($err) echo "CURL: $err\n";
echo "----\n$raw\n";
