<?php
/**
 * router_bridge.php
 * Puente HTTP -> SSFRouterClient (Spirit/Fusion)
 * Colócalo dentro de la raíz del proyecto (spiritWeb) o en /api/, ajustando el include.
 */
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');

// Ajusta esta ruta si lo pones en otra carpeta:
$routerClientPath = __DIR__ . "/Communication/SSFRouterClient.php";
if (!file_exists($routerClientPath)) {
  http_response_code(500);
  echo json_encode(["ok"=>false, "error"=>"SSFRouterClient.php no encontrado", "path"=>$routerClientPath]);
  exit;
}
require_once $routerClientPath;

$method = strtoupper($_REQUEST['method'] ?? 'POST');            // "POST" | "GET" según espera el router
$name   = trim($_REQUEST['name']   ?? '');                      // ej: REQ_PUMP_STATUS_ID_001
$body   = (string)($_REQUEST['body']   ?? '');                  // ej: LV=2
$readS  = (int)($_REQUEST['readSeconds'] ?? 2);                 // tiempo de espera de respuesta
if ($readS < 0 || $readS > 10) $readS = 2;

if ($name === '') {
  http_response_code(400);
  echo json_encode(["ok"=>false, "error"=>"Parámetro 'name' requerido (mensaje a enviar)"]);
  exit;
}

try {
  $cli = new SSFRouterClient();
  if (!$cli->OpenSocket()) {
    http_response_code(502);
    echo json_encode(["ok"=>false, "error"=>"No se pudo conectar con Message Router"]);
    exit;
  }
  $sent = $cli->SendMessage($method, $name, $body);
  if (!$sent) {
    $cli->CloseSocket();
    http_response_code(500);
    echo json_encode(["ok"=>false, "error"=>"Fallo al enviar mensaje al Router", "name"=>$name, "method"=>$method]);
    exit;
  }
  // Intento de lectura (si el framework lo soporta)
  // Muchas implementaciones exponen ReadMessage($seconds) y luego métodos getParameterValue(...).
  $cli->ReadMessage($readS);
  // Intentamos devolver algunos parámetros comunes si existen:
  $maybe = [];
  foreach (["STATUS","ERROR","INFO","MESSAGE","RESULT"] as $k) {
    if (method_exists($cli, "getParameterValue")) {
      $v = @$cli->getParameterValue($k);
      if ($v !== null && $v !== "") $maybe[$k] = $v;
    }
  }
  $cli->CloseSocket();
  echo json_encode([
    "ok"=>true,
    "sent"=>["method"=>$method,"name"=>$name,"body"=>$body],
    "readSeconds"=>$readS,
    "hints"=>$maybe
  ], JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(["ok"=>false, "error"=>$e->getMessage()]);
}
