<?php
declare(strict_types=1);
require_once __DIR__ . '/fusion_api_client.php';

$base = $_POST['base'] ?? ($_GET['base'] ?? 'http://172.17.125.102');
$client = new FusionApiClient($base);

$action = $_POST['action'] ?? $_GET['action'] ?? null;
$res = null;
switch($action){
    case 'prices':        $res = $client->getPrices(); break;
    case 'sales':         $res = $client->getSales($_POST['init'] ?? null, $_POST['end'] ?? null); break;
    case 'volume':        $res = $client->getVolumeByHose(); break;
    case 'attendants':    $res = $client->getAttendants(); break;
    case 'alarms':        $res = $client->getAlarms(); break;
    case 'modules':       $res = $client->getSystemModules(); break;
    case 'tanks':         $res = $client->getTanks(); break;
    case 'redirect_get':  $res = $client->changeGlanceRedirect(null); break;
    case 'redirect_set':  $res = $client->changeGlanceRedirect(isset($_POST['flag']) ? ($_POST['flag']==='1') : null); break;
    case 'translate':     $res = $client->translate($_POST['q'] ?? ''); break;
}

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function pretty($raw){ $j=json_decode($raw,true); return $j?json_encode($j,JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES):$raw; }
?>
<!doctype html><html lang="es"><meta charset="utf-8">
<title>Fusión API - Tester (endpoints provistos)</title>
<style>body{font-family:system-ui;background:#0b1022;color:#e5e7eb} .card{background:#111827;border:1px solid #1f2937;border-radius:12px;padding:14px;margin:12px auto;max-width:1100px} .row{display:flex;gap:10px;flex-wrap:wrap} input,select,textarea{background:#0b1022;color:#e5e7eb;border:1px solid #1f2937;border-radius:10px;padding:8px} .btn{padding:8px 12px;border-radius:10px;border:1px solid #1f2937;background:#0b1022;color:#e5e7eb;cursor:pointer} .btn:hover{opacity:.9} .pre{white-space:pre-wrap;background:#0b1022;border:1px solid #1f2937;padding:10px;border-radius:8px;max-height:400px;overflow:auto}</style>
<div class="card">
<h1>Fusión API - Tester (endpoints provistos)</h1>
<form method="post" class="row">
    <label>Base URL <input name="base" value="<?=h($base)?>" style="min-width:320px"></label>
    <button class="btn">Guardar</button>
</form>
</div>

<div class="card"><h2>Consultas</h2>
<form method="post" class="row" style="align-items:flex-end">
    <input type="hidden" name="base" value="<?=h($base)?>">
    <button class="btn" name="action" value="prices">/api/prices.php</button>
    <button class="btn" name="action" value="volume">/api/volumeByHose.php</button>
    <button class="btn" name="action" value="attendants">/api/attendant.php</button>
    <button class="btn" name="action" value="alarms">/api/alarms.php</button>
    <button class="btn" name="action" value="tanks">/api/tanks.php</button>
    <button class="btn" name="action" value="modules">/api/modules.php</button>
</form>
</div>

<div class="card"><h2>Ventas (rango opcional)</h2>
<form method="post" class="row" style="align-items:flex-end">
    <input type="hidden" name="base" value="<?=h($base)?>">
    <input name="init" placeholder="YYYYMMDD" style="width:140px">
    <input name="end" placeholder="YYYYMMDD" style="width:140px">
    <button class="btn" name="action" value="sales">/api/sales.php</button>
</form>
<div class="pre small">Si dejas en blanco: devuelve hoy/ayer, esta semana/mes, etc.</div>
</div>

<div class="card"><h2>Glance redirect (flag)</h2>
<form method="post" class="row" style="align-items:center">
    <input type="hidden" name="base" value="<?=h($base)?>">
    <button class="btn" name="action" value="redirect_get">Consultar /api/changeRedirect.php</button>
    <select name="flag"><option value="1">true</option><option value="0">false</option></select>
    <button class="btn" name="action" value="redirect_set">Establecer</button>
</form>
</div>

<div class="card"><h2>Translate</h2>
<form method="post" class="row" style="align-items:flex-end">
    <input type="hidden" name="base" value="<?=h($base)?>">
    <input name="q" placeholder="Texto a traducir" style="min-width:320px">
    <button class="btn" name="action" value="translate">/api/translate.php</button>
</form>
</div>

<?php if ($res!==null): ?>
<div class="card">
    <h2>Resultado</h2>
    <div>Código: <?=h((string)$res['status'])?></div>
    <h3>JSON</h3>
    <div class="pre"><?=h(pretty($res['raw'] ?? ''))?></div>
</div>
<?php endif; ?>
