<?php
// Incluir configuración desde el archivo db.php
$config = include('db.php');

try {
    $dsn = "mysql:host={$config['host']};port={$config['port']};dbname={$config['dbname']};charset={$config['charset']}";
    $pdo = new PDO($dsn, $config['user'], $config['pass']);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Error al conectar a la base de datos: " . $e->getMessage());
}

// Inicializar variables
$mensaje = "";
$fechaInicio = $_GET['fecha_inicio'] ?? '';
$fechaFinal = $_GET['fecha_final'] ?? '';
$resultados = [];

// Consultar cuadres históricos
if ($_SERVER['REQUEST_METHOD'] === 'GET' && !empty($fechaInicio) && !empty($fechaFinal)) {
    $stmt = $pdo->prepare("SELECT DISTINCT session_id, MIN(fecha_inicio) AS fecha_inicio, MAX(fecha_final) AS fecha_final, nombre_bombero, SUM(valor) AS total_valor 
                            FROM cuadre_bomberos_historico 
                            WHERE fecha_inicio BETWEEN :fecha_inicio AND :fecha_final 
                            GROUP BY session_id, nombre_bombero 
                            ORDER BY fecha_inicio DESC");
    $stmt->execute([':fecha_inicio' => $fechaInicio, ':fecha_final' => $fechaFinal]);
    $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($resultados)) {
        $mensaje = "No se encontraron cuadres dentro del rango de fechas seleccionado.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Histórico de Cuadres</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css">
</head>
<body>
<header class="bg-primary text-white p-3">
    <div class="container d-flex justify-content-between align-items-center">
        <h2 class="m-0">Histórico de Cuadres</h2>
        <a href="/cuadrebomberos.php" class="btn btn-light btn-sm">Regresar</a>
    </div>
</header>
<main class="container py-4">
    <div class="card shadow">
        <div class="card-body">
            <h1 class="card-title mb-4 text-center">Consulta de Cuadres Realizados</h1>
            <?php if (!empty($mensaje)): ?>
                <div class="alert alert-warning"><?= $mensaje ?></div>
            <?php endif; ?>
            <form method="GET" class="row g-3 mb-4">
                <div class="col-md-5">
                    <label class="form-label">Fecha Inicio:</label>
                    <input type="date" name="fecha_inicio" class="form-control" value="<?= htmlspecialchars($fechaInicio) ?>" required>
                </div>
                <div class="col-md-5">
                    <label class="form-label">Fecha Final:</label>
                    <input type="date" name="fecha_final" class="form-control" value="<?= htmlspecialchars($fechaFinal) ?>" required>
                </div>
                <div class="col-md-2 align-self-end">
                    <button type="submit" class="btn btn-primary w-100">Buscar</button>
                </div>
            </form>

            <?php if (!empty($resultados)): ?>
            <h3>Resultados:</h3>
            <table class="table table-striped table-bordered mt-4">
                <thead>
                    <tr>
                        <th>ID Sessión</th>
                        <th>Bombero</th>
                        <th>Fecha Inicio</th>
                        <th>Fecha Final</th>
                        <th>Total Valor</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($resultados as $resultado): ?>
                    <tr>
                        <td><?= htmlspecialchars($resultado['session_id']) ?></td>
                        <td><?= htmlspecialchars($resultado['nombre_bombero']) ?></td>
                        <td><?= htmlspecialchars($resultado['fecha_inicio']) ?></td>
                        <td><?= htmlspecialchars($resultado['fecha_final']) ?></td>
                        <td><?= htmlspecialchars(number_format($resultado['total_valor'], 2)) ?></td>
                        <td>
                            <form action="generar-reporte.php" method="GET" class="d-inline">
                                <input type="hidden" name="session_id" value="<?= htmlspecialchars($resultado['session_id']) ?>">
                                <button type="submit" class="btn btn-success btn-sm">Imprimir</button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php else: ?>
            <p class="text-muted text-center">Realiza una búsqueda para ver cuadres históricos.</p>
            <?php endif; ?>
        </div>
    </div>
</main>
</body>
</html>