<?php
// Conexión externa vía API
$curl = curl_init();

curl_setopt_array($curl, [
    CURLOPT_URL => 'http://localhost/fuelpos/api.php?action=get_pumps',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPGET => true,
    CURLOPT_HEADER => false
]);

$response = curl_exec($curl);
curl_close($curl);

$pumps = json_decode($response, true);

// Validación de datos obtenidos
if (!$pumps || !isset($pumps['ok']) || !$pumps['ok'] || !isset($pumps['pumps'])) {
    die('Error al obtener los surtidores');
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Comprobantes</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .surtidor-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 20px;
        }
        .surtidor-grid .surtidor-card {
            display: flex;
            align-items: center;
            justify-content: center;
            height: 140px;
            width: 100%;
            text-align: center;
            font-size: 1.2rem;
            font-weight: bold;
            background-color: #007bff;
            color: white;
            border-radius: 10px;
            transition: transform 0.2s ease-in-out, box-shadow 0.2s;
            cursor: pointer;
        }
        .surtidor-grid .surtidor-card:hover {
            transform: scale(1.05);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
        }
    </style>
</head>
<body>
    <div class="container mt-4">
        <h1 class="text-center mb-4">Surtidores</h1>
        <div class="surtidor-grid">
            <?php foreach ($pumps['pumps'] as $pump): ?>
                <a href="ventas.php?pump_id=<?= htmlspecialchars($pump['id']) ?>" class="surtidor-card">
                    <?= htmlspecialchars($pump['name']) ?>
                </a>
            <?php endforeach; ?>
        </div>
    </div>
</body>
</html>