<?php
// Incluir la conexión a la base de datos
include 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $codigo = $_POST['codigo'];
    $tipo = $_POST['tipo'];
    $secuencia_inicial = $_POST['secuencia_inicial'];
    $secuencia_final = $_POST['secuencia_final'];
    $secuencia_actual = $_POST['secuencia_actual'];

    try {
        $sql = "INSERT INTO comprobantes_fiscales (codigo_comprobante, tipo_comprobante, secuencia_inicial, secuencia_final, secuencia_actual)
                VALUES (?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->execute([$codigo, $tipo, $secuencia_inicial, $secuencia_final, $secuencia_actual]);

        header("Location: index.php");
        exit;
    } catch (PDOException $e) {
        die("Error al agregar el comprobante: " . $e->getMessage());
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Agregar Comprobante</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <h1 class="text-center">Agregar Comprobante</h1>
        <form method="POST">
            <div class="mb-3">
                <label for="codigo" class="form-label">Código</label>
                <input type="text" name="codigo" id="codigo" class="form-control" maxlength="3" required>
            </div>
            <div class="mb-3">
                <label for="tipo" class="form-label">Tipo de Comprobante</label>
                <input type="text" name="tipo" id="tipo" class="form-control" required>
            </div>
            <div class="mb-3">
                <label for="secuencia_inicial" class="form-label">Secuencia Inicial</label>
                <input type="number" name="secuencia_inicial" id="secuencia_inicial" class="form-control" required>
            </div>
            <div class="mb-3">
                <label for="secuencia_final" class="form-label">Secuencia Final</label>
                <input type="number" name="secuencia_final" id="secuencia_final" class="form-control" required>
            </div>
            <div class="mb-3">
                <label for="secuencia_actual" class="form-label">Secuencia Actual</label>
                <input type="number" name="secuencia_actual" id="secuencia_actual" class="form-control" required>
            </div>
            <button type="submit" class="btn btn-success">Agregar</button>
            <a href="index.php" class="btn btn-secondary">Cancelar</a>
        </form>
    </div>
</body>
</html>