<?php
// Ruta al archivo de configuración
$config = require __DIR__ . '/../config.php'; // Regresa al directorio raíz para cargar config.php

// Establecer la zona horaria desde el archivo de configuración
date_default_timezone_set($config->timezone);

try {
    // Crear conexión utilizando los datos de config.php
    $conn = new PDO(
        "mysql:host={$config->db_host};dbname={$config->db_name};charset=utf8mb4",
        $config->db_user,
        $config->db_pass
    );
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION); // Activar excepciones en caso de error
} catch (PDOException $e) {
    die("Error de conexión a la base de datos: " . $e->getMessage());
}
?>