<?php
// Incluir la conexión a la base de datos
include 'db.php';

// Verificar si se ha pasado un ID
if (!isset($_GET['id'])) {
    die("Error: No se proporcionó un ID válido.");
}

$id = intval($_GET['id']); // Asegura que el ID sea un número entero

// Obtener los datos del comprobante a editar
try {
    $stmt = $conn->prepare("SELECT * FROM comprobantes_fiscales WHERE id = ?");
    $stmt->execute([$id]);
    $comprobante = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$comprobante) {
        die("Error: No se encontró el comprobante con el ID proporcionado.");
    }
} catch (PDOException $e) {
    die("Error al obtener el comprobante: " . $e->getMessage());
}

// Procesar la actualización del formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $codigo = $_POST['codigo'];
    $tipo = $_POST['tipo'];
    $secuencia_inicial = $_POST['secuencia_inicial'];
    $secuencia_final = $_POST['secuencia_final'];
    $secuencia_actual = $_POST['secuencia_actual'];

    try {
        $sql = "UPDATE comprobantes_fiscales SET codigo_comprobante = ?, tipo_comprobante = ?, secuencia_inicial = ?, secuencia_final = ?, secuencia_actual = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->execute([$codigo, $tipo, $secuencia_inicial, $secuencia_final, $secuencia_actual, $id]);

        header("Location: index.php");
        exit;
    } catch (PDOException $e) {
        die("Error al actualizar el comprobante: " . $e->getMessage());
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Comprobante</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <h1 class="text-center">Editar Comprobante Fiscal</h1>
        <form method="POST">
            <div class="mb-3">
                <label for="codigo" class="form-label">Código Comprobante</label>
                <input type="text" name="codigo" id="codigo" class="form-control" maxlength="3" value="<?= htmlspecialchars($comprobante['codigo_comprobante']) ?>" required>
            </div>
            <div class="mb-3">
                <label for="tipo" class="form-label">Tipo de Comprobante</label>
                <input type="text" name="tipo" id="tipo" class="form-control" value="<?= htmlspecialchars($comprobante['tipo_comprobante']) ?>" required>
            </div>
            <div class="mb-3">
                <label for="secuencia_inicial" class="form-label">Secuencia Inicial</label>
                <input type="number" name="secuencia_inicial" id="secuencia_inicial" class="form-control" value="<?= htmlspecialchars($comprobante['secuencia_inicial']) ?>" required>
            </div>
            <div class="mb-3">
                <label for="secuencia_final" class="form-label">Secuencia Final</label>
                <input type="number" name="secuencia_final" id="secuencia_final" class="form-control" value="<?= htmlspecialchars($comprobante['secuencia_final']) ?>" required>
            </div>
            <div class="mb-3">
                <label for="secuencia_actual" class="form-label">Secuencia Actual</label>
                <input type="number" name="secuencia_actual" id="secuencia_actual" class="form-control" value="<?= htmlspecialchars($comprobante['secuencia_actual']) ?>" required>
            </div>
            <button type="submit" class="btn btn-success">Actualizar</button>
            <a href="index.php" class="btn btn-secondary">Cancelar</a>
        </form>
    </div>
</body>
</html>