<?php
// Incluir conexión a la base de datos
include 'db.php';
session_start();

// Validar que el ID de la venta, el RNC y el tipo de comprobante estén disponibles
$selectedSaleId = $_SESSION['selected_sale_id'] ?? null;
$rnc_client = $_SESSION['rnc_client'] ?? null;
$tipo_comprobante = $_SESSION['tipo_comprobante'] ?? null;

if (!$selectedSaleId || !$rnc_client || !$tipo_comprobante) {
    die('Error: Falta información para generar el comprobante.');
}

// Obtener el código y la secuencia del comprobante seleccionado
$stmt = $conn->prepare("SELECT codigo_comprobante, secuencia_actual FROM comprobantes_fiscales WHERE tipo_comprobante = ?");
$stmt->execute([$tipo_comprobante]);
$comprobanteData = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$comprobanteData) {
    die('Error: No se encontraron datos para el tipo de comprobante seleccionado.');
}

$codigo_comprobante = $comprobanteData['codigo_comprobante'];
$secuencia = str_pad($comprobanteData['secuencia_actual'], 10, '0', STR_PAD_LEFT);

// Generar el número completo del comprobante
$comprobanteCompleto = $codigo_comprobante . $secuencia;

// Incrementar la secuencia en la base de datos
$newSecuencia = $comprobanteData['secuencia_actual'] + 1;
$updateStmt = $conn->prepare("UPDATE comprobantes_fiscales SET secuencia_actual = ? WHERE tipo_comprobante = ?");
$updateStmt->execute([$newSecuencia, $tipo_comprobante]);

// Obtener datos del cliente usando el RNC
$stmt = $conn->prepare("SELECT codigornc, empresa FROM RNC WHERE codigornc = ?");
$stmt->execute([$rnc_client]);
$clientData = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$clientData) {
    die('Error: No se encontró información asociada al RNC del cliente.');
}

// Obtener datos de la venta seleccionada
$saleStmt = $conn->prepare("
    SELECT 
        si.qty, 
        p.name AS product_name, 
        si.unit_price, 
        ROUND(si.qty * si.unit_price, 2) AS total
    FROM sale_items si
    JOIN products p ON p.id = si.product_id
    WHERE si.sale_id = ?
");
$saleStmt->execute([$selectedSaleId]);
$saleData = $saleStmt->fetch(PDO::FETCH_ASSOC);
if (!$saleData) {
    die('Error: No se encontraron detalles para la venta seleccionada.');
}

// Obtener datos de la estación
$stationStmt = $conn->query("SELECT nombre, direccion, telefono, rnc FROM estacion LIMIT 1");
$stationData = $stationStmt->fetch(PDO::FETCH_ASSOC);
if (!$stationData) {
    die('Error: No se encontraron datos de la estación.');
}

// Detalles de ventas y cálculo de totales
$cantidad = intval($_SESSION['selected_qty']);
$producto = htmlspecialchars($_SESSION['selected_product_name']);
$precioUnitario = floatval($_SESSION['selected_unit_price']);
$total = floatval($_SESSION['selected_total']);
$fechaHoraImpresion = date('d/m/Y H:i:s');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imprimir Comprobante</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; padding: 10px; border: 1px solid #ddd; }
        h1, h2, h3 { text-align: center; }
        .bold { font-weight: bold; }
        .comprobante { font-size: 1.4rem; font-weight: bold; text-align: center; }
        .detalle { margin-top: 30px; }
        .detalle table { width: 100%; border-collapse: collapse; }
        .detalle th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        .detalle th { background-color: #f4f4f4; }
        .footer { margin-top: 40px; text-align: right; }
		<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imprimir Comprobante</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            padding: 10px;
            border: 1px solid #ddd;
            text-align: center;
        }
        h1, h2, h3 {
            text-align: center;
        }
        .actions {
            display: flex;
            justify-content: center;
            gap: 20px;
            margin-top: 20px;
        }
        button.btn {
            background-color: #007bff;
            color: #fff;
            font-size: 1.2rem;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s ease, transform 0.2s ease;
        }
        button.btn:hover {
            background-color: #0056b3;
            transform: translateY(-2px);
            box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
        }
    </style>
</head>
    </style>
    <script>
        function imprimir() {
            window.print();
        }

        function aceptar() {
            window.location.href = 'facturas.php';
        }
    </script>
</head>
<body>
    <h1><?= htmlspecialchars($stationData['nombre']) ?></h1>
    <p><?= htmlspecialchars($stationData['direccion']) ?><br>
        Teléfono: <?= htmlspecialchars($stationData['telefono']) ?><br>
        RNC: <?= htmlspecialchars($stationData['rnc']) ?></p>
    <h2>FACTURA CON VALOR FISCAL</h2>
    <p><strong>RNC del Cliente:</strong> <?= htmlspecialchars($clientData['codigornc']) ?><br>
        <strong>Nombre del Cliente:</strong> <?= htmlspecialchars($clientData['empresa']) ?><br>
        <strong>Fecha y Hora:</strong> <?= htmlspecialchars($fechaHoraImpresion) ?></p>
    <h3 class="comprobante">Comprobante Fiscal: <?= htmlspecialchars($comprobanteCompleto) ?></h3>
    <div class="detalle">
        <table>
            <thead>
            <tr>
                <th>Cantidad</th>
                <th>Producto</th>
                <th>Precio Unitario</th>
                <th>Valor</th>
            </tr>
            </thead>
            <tbody>
            <tr>
                <td><?= number_format($cantidad, 3) ?></td>
                <td><?= htmlspecialchars($producto) ?></td>
                <td>$<?= number_format($precioUnitario, 2) ?></td>
                <td>$<?= number_format($total, 2) ?></td>
            </tr>
            </tbody>
        </table>
    </div>
    <div class="footer">
        <p><strong>Monto:</strong> $<?= number_format($total, 2) ?><br>
            <strong>Impuesto:</strong> $0.00<br>
            <strong>Total:</strong> $<?= number_format($total, 2) ?></p>
    </div>

    <div class="actions">
	     <button class="btn" onclick="aceptar()">Aceptar</button>
         <button class="btn" onclick="imprimir()">Imprimir</button>
        
    </div>
</body>
</html>
