<?php
// Incluir conexión a la base de datos
include 'db.php';
session_start();

// Validar que existan datos de la venta seleccionada enviados desde el formulario de ventas.php
if (
    empty($_POST['selected_sale_id']) || empty($_POST['selected_qty']) ||
    empty($_POST['selected_product_name']) || empty($_POST['selected_unit_price']) ||
    empty($_POST['selected_total'])
) {
    die('Error: Faltan datos para generar el ticket.');
}

// Obtener y almacenar los datos enviados en la sesión
$_SESSION['selected_sale_id'] = $_POST['selected_sale_id'];
$_SESSION['selected_qty'] = $_POST['selected_qty'];
$_SESSION['selected_product_name'] = $_POST['selected_product_name'];
$_SESSION['selected_unit_price'] = $_POST['selected_unit_price'];
$_SESSION['selected_total'] = $_POST['selected_total'];

// Obtener datos de la estación (nombre, dirección, teléfono)
$stationStmt = $conn->query("SELECT nombre, direccion, telefono FROM estacion LIMIT 1");
$stationData = $stationStmt->fetch(PDO::FETCH_ASSOC);
if (!$stationData) {
    die('Error: No se encontraron datos de la estación.');
}

// Detalles de ventas y cálculos
$cantidad = $_SESSION['selected_qty'];
$producto = $_SESSION['selected_product_name'];
$precioUnitario = $_SESSION['selected_unit_price'];
$total = $_SESSION['selected_total'];
$fechaHoraImpresion = date('d/m/Y H:i:s');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imprimir Ticket</title>
    <style>
        body {
            font-family: Arial, sans-serif; /* Cambié a la fuente de imprimir_comprobante.php */
            font-size: 16px; /* Aumenté el tamaño de la fuente */
            margin: 20px;
            text-align: center;
        }
        .container {
            border: 1px dashed #000;
            padding: 20px;
            width: 350px; /* Más ancho que antes */
            margin: 20px auto;
        }
        h1, h2 {
            text-align: center;
        }
        .ticket-data {
            margin-top: 20px;
            text-align: left;
        }
        .ticket-footer {
            display: flex;
            flex-direction: column; /* Cambié orientación a columna */
            align-items: center; /* Centrado horizontal */
            margin-top: 25px;
        }
        .ticket-footer .thank-you {
            font-size: 1.2rem; /* Tamaño de fuente para "Gracias por su compra" */
            margin-bottom: 15px; /* Espacio entre el texto y los botones */
            font-weight: bold; /* Texto más prominente */
        }
        .ticket-footer .buttons {
            display: flex;
            gap: 15px; /* Espacio entre los botones */
        }
        .ticket-footer button {
            font-size: 1.2rem; /* Tamaño de letra mayor */
            padding: 12px 30px; /* Tamaño uniforme de botones */
            background-color: #007bff;
            color: #fff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s ease, transform 0.2s ease;
        }
        .ticket-footer button:hover {
            background-color: #0056b3;
            transform: translateY(-2px);
            box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
        }
    </style>
    <script>
        function imprimir() {
            window.print();
        }

        function aceptar() {
            window.location.href = 'facturas.php';
        }
    </script>
</head>
<body>
    <div class="container">
        <h1><?= htmlspecialchars($stationData['nombre']) ?></h1>
        <p><?= htmlspecialchars($stationData['direccion']) ?><br>
            Teléfono: <?= htmlspecialchars($stationData['telefono']) ?><br>
            Fecha y Hora: <?= htmlspecialchars($fechaHoraImpresion) ?>
        </p>
        <h2>Ticket</h2>
        <div class="ticket-data">
            <p><strong>Producto:</strong> <?= htmlspecialchars($producto) ?></p>
            <p><strong>Cantidad:</strong> <?= number_format($cantidad, 3) ?></p>
            <p><strong>Precio Unitario:</strong> $<?= number_format($precioUnitario, 2) ?></p>
            <p><strong>Total:</strong> $<?= number_format($total, 2) ?></p>
        </div>
        <div class="ticket-footer">
            <!-- Mensaje centrado arriba -->
            <p class="thank-you">Gracias por su compra</p>
            <!-- Botones centrados debajo -->
            <div class="buttons">
			    <button onclick="aceptar()">Aceptar</button>
                <button onclick="imprimir()">Imprimir Ticket</button>
               
            </div>
        </div>
    </div>
</body>
</html>