<?php
// Incluir la conexión a la base de datos
include 'db.php';

// Procesar el formulario cuando se presiona el botón "Aplicar"
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['rnc_file'])) {
    // Revisar si se subió el archivo correctamente
    if ($_FILES['rnc_file']['error'] === UPLOAD_ERR_OK) {
        $file_tmp_name = $_FILES['rnc_file']['tmp_name'];
        
        // Leer el contenido del archivo
        $file_content = file($file_tmp_name, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        
        // Preparar la consulta para insertar en la tabla RNC
        $stmt = $conn->prepare("INSERT INTO RNC (codigornc, empresa) VALUES (:codigornc, :empresa)");
        
        // Procesar cada línea del archivo
        foreach ($file_content as $line) {
            $fields = explode('|', $line); // Separar los campos por "|"
            if (count($fields) >= 2) { // Asegurarse de que haya al menos dos campos
                $codigornc = $fields[0];
                $empresa = $fields[1];
                
                // Insertar en la base de datos
                $stmt->execute([
                    ':codigornc' => $codigornc,
                    ':empresa' => $empresa
                ]);
            }
        }
        
        echo "<div class='alert alert-success text-center'>Datos cargados satisfactoriamente en la tabla RNC.</div>";
    } else {
        echo "<div class='alert alert-danger text-center'>Error al subir el archivo. Inténtelo de nuevo.</div>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Comprobantes Fiscales</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <h1 class="text-center">Comprobantes Fiscales</h1>
        <a href="create.php" class="btn btn-primary mb-3">Agregar Comprobante</a>
        
        <!-- Botones adicionales -->
        <div class="mb-4">
            <form action="" method="POST" enctype="multipart/form-data">
                <div class="mb-2">
                    <label for="rnc_file" class="form-label">Subir archivo para actualizar RNC</label>
                    <input type="file" class="form-control" id="rnc_file" name="rnc_file" accept=".txt" required>
                </div>
                <button type="submit" class="btn btn-outline-success">Aplicar</button>
            </form>
        </div>

        <table class="table table-bordered table-striped">
            <thead class="table-dark">
                <tr>
                    <th>ID</th>
                    <th>Código Comprobante</th>
                    <th>Tipo</th>
                    <th>Secuencia Inicial</th>
                    <th>Secuencia Final</th>
                    <th>Secuencia Actual</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php
                try {
                    $stmt = $conn->query("SELECT * FROM comprobantes_fiscales ORDER BY id ASC");
                    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)): ?>
                    <tr>
                        <td><?= htmlspecialchars($row['id']) ?></td>
                        <td><?= htmlspecialchars($row['codigo_comprobante']) ?></td>
                        <td><?= htmlspecialchars($row['tipo_comprobante']) ?></td>
                        <td><?= htmlspecialchars($row['secuencia_inicial']) ?></td>
                        <td><?= htmlspecialchars($row['secuencia_final']) ?></td>
                        <td><?= htmlspecialchars($row['secuencia_actual']) ?></td>
                        <td>
                            <a href="edit.php?id=<?= $row['id'] ?>" class="btn btn-warning btn-sm">Editar</a>
                            <a href="delete.php?id=<?= $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('¿Estás seguro?');">Eliminar</a>
                        </td>
                    </tr>
                    <?php endwhile;
                } catch (PDOException $e) {
                    echo "<tr><td colspan='7' class='text-danger text-center'>Error: {$e->getMessage()}</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</body>
</html>