<?php
// Incluir la conexión a la base de datos
include 'db.php';
session_start();

// Validar que el ID de la venta fue enviado
$selectedSaleId = $_POST['selected_sale_id'] ?? $_SESSION['selected_sale_id'] ?? null;
$selectedQty = $_POST['selected_qty'] ?? $_SESSION['selected_qty'] ?? null;
$selectedProductName = $_POST['selected_product_name'] ?? $_SESSION['selected_product_name'] ?? null;
$selectedUnitPrice = $_POST['selected_unit_price'] ?? $_SESSION['selected_unit_price'] ?? null;
$selectedTotal = $_POST['selected_total'] ?? $_SESSION['selected_total'] ?? null;

if (!$selectedSaleId) {
    die('Error: No se seleccionó ninguna venta.');
}

// Guardar información de la venta seleccionada en la sesión
$_SESSION['selected_sale_id'] = $selectedSaleId;
$_SESSION['selected_qty'] = $selectedQty;
$_SESSION['selected_product_name'] = $selectedProductName;
$_SESSION['selected_unit_price'] = $selectedUnitPrice;
$_SESSION['selected_total'] = $selectedTotal;

$rnc_error = '';
$rnc_data = null;
$comprobantes = [];
$selected_tipo_comprobante = null;

// Validar si el cliente fue buscado y el formulario se envió correctamente con el RNC
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    if ($_POST['action'] === 'buscar') {
        // Procesar búsqueda del RNC
        $rnc_client = trim($_POST['rnc_client'] ?? '');
        if ($rnc_client !== '') {
            $stmt = $conn->prepare("SELECT codigornc, empresa FROM RNC WHERE codigornc = ?");
            $stmt->execute([$rnc_client]);
            $rnc_data = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$rnc_data) {
                $rnc_error = 'No se encontró ningún cliente con este RNC.';
            } else {
                // Guardar RNC en la sesión
                $_SESSION['rnc_client'] = $rnc_client;
            }
        } else {
            $rnc_error = 'El campo RNC no puede estar vacío.';
        }

    } elseif ($_POST['action'] === 'imprimir') {
        // Procesar impresión
        $selected_tipo_comprobante = trim($_POST['tipo_comprobante']);
        if (!$selected_tipo_comprobante) {
            $rnc_error = 'Por favor, seleccione un tipo de comprobante.';
        } else {
            $_SESSION['tipo_comprobante'] = $selected_tipo_comprobante;

            // Redirigir a imprimir_comprobante.php
            header("Location: imprimir_comprobante.php");
            exit;
        }
    }
}

// Obtener los tipos de comprobantes fiscales de la base de datos
$comprobanteStmt = $conn->query("SELECT tipo_comprobante FROM comprobantes_fiscales");
$comprobantes = $comprobanteStmt->fetchAll(PDO::FETCH_COLUMN);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ingresar RNC</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .spinner-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(255, 255, 255, 0.8);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 9999;
            display: none;
        }
        .spinner-border {
            width: 3rem;
            height: 3rem;
        }
    </style>
    <script>
        // Mostrar el spinner en el evento de envío del formulario
        function mostrarSpinner() {
            const spinnerOverlay = document.getElementById('spinner-overlay');
            spinnerOverlay.style.display = 'flex';
        }
    </script>
</head>
<body>
    <div class="container mt-5">
        <h1 class="text-center">Ingresar RNC del Cliente</h1>

        <!-- Formulario de búsqueda del RNC -->
        <form method="POST" class="mb-3" onsubmit="mostrarSpinner()">
            <input type="hidden" name="action" value="buscar">
            <input type="hidden" name="selected_sale_id" value="<?= htmlspecialchars($selectedSaleId) ?>">
            <div class="mb-3">
                <label for="rnc_client" class="form-label">Número RNC</label>
                <input type="text" name="rnc_client" id="rnc_client" class="form-control" value="<?= htmlspecialchars($_POST['rnc_client'] ?? '') ?>" required>
            </div>
            <button type="submit" class="btn btn-primary">Buscar</button>
        </form>

        <!-- Mostrar error o datos del cliente -->
        <?php if ($rnc_error): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($rnc_error) ?></div>
        <?php elseif ($rnc_data): ?>
            <div class="alert alert-success">
                <strong>Cliente encontrado:</strong><br>
                <strong>RNC:</strong> <?= htmlspecialchars($rnc_data['codigornc']) ?><br>
                <strong>Nombre:</strong> <?= htmlspecialchars($rnc_data['empresa']) ?>
            </div>
        <?php endif; ?>

        <!-- Selección del tipo de comprobante -->
        <?php if ($rnc_data): ?>
            <form method="POST">
                <input type="hidden" name="action" value="imprimir">
                <input type="hidden" name="selected_sale_id" value="<?= htmlspecialchars($selectedSaleId) ?>">
                <div class="mb-3">
                    <label for="tipo_comprobante" class="form-label">Tipo de Comprobante</label>
                    <select name="tipo_comprobante" id="tipo_comprobante" class="form-select" required>
                        <option value="">-- Seleccione --</option>
                        <?php foreach ($comprobantes as $comprobante): ?>
                            <option value="<?= htmlspecialchars($comprobante) ?>" <?= $selected_tipo_comprobante === $comprobante ? 'selected' : '' ?>>
                                <?= htmlspecialchars($comprobante) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <button type="submit" class="btn btn-success">Imprimir</button>
            </form>
        <?php endif; ?>
    </div>

    <!-- Spinner de carga -->
    <div id="spinner-overlay" class="spinner-overlay">
        <div class="spinner-border text-primary" role="status">
            <span class="visually-hidden">Cargando...</span>
        </div>
    </div>
</body>
</html>