<?php
// Incluir la conexión
include 'db.php';

$rnc_error = '';
$rnc_data = null;

// Buscar cliente por RNC
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $rnc_client = $_POST['rnc_client'];
    $stmt = $conn->prepare("SELECT codigornc, empresa FROM RNC WHERE codigornc = ?");
    $stmt->execute([$rnc_client]);
    $rnc_data = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$rnc_data) {
        $rnc_error = 'No se encontró ningún cliente con este RNC.';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Buscar RNC</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <h1 class="text-center">Buscar RNC</h1>
        <form method="POST" class="mb-3">
            <div class="mb-3">
                <label for="rnc_client" class="form-label">Número RNC</label>
                <input type="text" name="rnc_client" id="rnc_client" class="form-control" required>
            </div>
            <button type="submit" class="btn btn-primary">Buscar</button>
        </form>

        <?php if ($rnc_error): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($rnc_error) ?></div>
        <?php elseif ($rnc_data): ?>
            <div class="alert alert-success">
                RNC: <?= htmlspecialchars($rnc_data['codigornc']) ?><br>
                Nombre: <?= htmlspecialchars($rnc_data['empresa']) ?>
            </div>
            <a href="imprimir_comprobante.php?rnc=<?= $rnc_data['codigornc'] ?>" class="btn btn-warning">Imprimir Comprobante</a>
        <?php endif; ?>
    </div>
</body>
</html>