<?php
require __DIR__ . '/../init.php';
$pdo = pdo();
$id = (int)($_GET['id'] ?? 0);
$stmt = $pdo->prepare("SELECT s.*, u.username FROM sales s LEFT JOIN users u ON u.id=s.user_id WHERE s.id=?");
$stmt->execute([$id]);
$sale = $stmt->fetch();
if (!$sale) die("Venta no encontrada");
$items = $pdo->prepare("SELECT si.*, p.name FROM sale_items si JOIN products p ON p.id=si.product_id WHERE si.sale_id=?");
$items->execute([$id]);
$items = $items->fetchAll();
?>
<!doctype html><html><head><meta charset="utf-8"><title>Recibo <?= htmlspecialchars($sale['sale_code']) ?></title>
<style>body{font-family:Arial, sans-serif; max-width:420px; margin:20px auto;} .total{font-size:20px; font-weight:bold;}</style>
</head><body onload="window.print()">
<div>
  <h3>FuelPOS</h3>
  <div>Recibo: <?= htmlspecialchars($sale['sale_code']) ?></div>
  <div>Fecha: <?= $sale['created_at'] ?></div>
  <hr>
  <div>
    <?php foreach($items as $it): ?>
      <div style="display:flex;justify-content:space-between;padding:4px 0;">
        <div><?= htmlspecialchars($it['name']) ?> x <?= $it['qty'] ?></div>
        <div>$<?= number_format($it['total'],2) ?></div>
      </div>
    <?php endforeach; ?>
  </div>
  <hr>
  <div class="total">Total: $<?= number_format($sale['total'],2) ?></div>
  <div>Metodo: <?= htmlspecialchars($sale['payment_method']) ?></div>
</div>
</body></html>