<?php
// api/init_db.php - Script sencillo para crear la DB SQLite (opcional).
$dbFile = __DIR__ . '/../data/bitcoin.db';
if (!is_dir(dirname($dbFile))) {
    mkdir(dirname($dbFile), 0755, true);
}
try {
    $pdo = new PDO('sqlite:' . $dbFile);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->exec("CREATE TABLE IF NOT EXISTS prices (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        ts INTEGER NOT NULL,
        price REAL NOT NULL
    );");
    $pdo->exec("CREATE INDEX IF NOT EXISTS idx_ts ON prices(ts);");
    echo "Base de datos inicializada en: $dbFile\n";
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    exit(1);
}