<?php
// api/db_status.php - devuelve estado de la BD SQLite (conteo y últimas filas) en JSON
header('Content-Type: application/json; charset=utf-8');

$dbFile = __DIR__ . '/../data/bitcoin.db';
if (!file_exists($dbFile)) {
    echo json_encode(['ok' => false, 'error' => 'db_not_found', 'path' => realpath(dirname($dbFile)) . DIRECTORY_SEPARATOR . basename($dbFile)]);
    exit;
}

try {
    $pdo = new PDO('sqlite:' . $dbFile);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $stmt = $pdo->query('SELECT COUNT(*) AS cnt FROM prices');
    $cnt = $stmt->fetch(PDO::FETCH_ASSOC)['cnt'];

    $stmt = $pdo->query('SELECT ts, price FROM prices ORDER BY ts DESC LIMIT 10');
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'ok' => true,
        'db' => $dbFile,
        'count' => (int)$cnt,
        'last_samples' => array_map(function($r){
            return ['ts' => (int)$r['ts'], 'price' => (float)$r['price']];
        }, $rows),
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
} catch (Exception $e) {
    echo json_encode(['ok' => false, 'error' => 'exception', 'message' => $e->getMessage()]);
}